/*
 * Decompiled with CFR 0.152.
 */
package com.postoaki.venda.com.postoaki.venda.dto;

import org.apache.commons.lang3.StringUtils;

public enum EnumModalidadeProdutoServico {
    GASOLINA("Gasolina", "1-GASOLINA COM", 1, 2382, "320102001"),
    GASOLINA_ADITIVADA("Gasolina Aditivada", "4-GASOLINA ADI", 3, 2383, "320102002"),
    GASOLINA_PODIUM("Gasolina Podium", "", -1, 2384),
    GASOLINA_PREMIUM("Gasolina Premium", "", -1, 14601),
    ETANOL("Etanol", "2-ETANOL", 2, 2387, "810101001"),
    DIESEL("Diesel S500", "3-DIESEL", 4, 2394, "820101012"),
    DIESEL_S500_ADITIVADO("Diesel S500 Aditivado", "", -1, 2386),
    DIESEL_ADITIVADO("Diesel S10", "5-DIESEL S-10", 5, 8777, "820101034"),
    DIESEL_S10_ADITIVADO("Diesel S10 Aditivado", "", -1, 16846),
    TROCA_OLEO("Troca de Oleo"),
    ARLA32("Arla 32", "", -1, 14159),
    GNV("G.N.V.", "", -1, 2452),
    QUEROSENE("Querosene", "", -1, 2449),
    OUTRO("Outro");

    private String descricao;
    private String descricaoIntegracao;
    private int identificadorExternoProdutoKurujao;
    private int identificadorExternoProdutoSim;
    private String codigoAnp;

    private EnumModalidadeProdutoServico(String descricao) {
        this.descricao = descricao;
    }

    private EnumModalidadeProdutoServico(String descricao, String descricaoIntegracao, int codigoKurujao) {
        this.descricao = descricao;
        this.descricaoIntegracao = descricaoIntegracao;
        this.identificadorExternoProdutoKurujao = codigoKurujao;
    }

    private EnumModalidadeProdutoServico(String descricao, String descricaoIntegracao, int codigoKurujao, int codigoSim) {
        this.descricao = descricao;
        this.descricaoIntegracao = descricaoIntegracao;
        this.identificadorExternoProdutoKurujao = codigoKurujao;
        this.identificadorExternoProdutoSim = codigoSim;
    }

    private EnumModalidadeProdutoServico(String descricao, String descricaoIntegracao, int codigoKurujao, int codigoSim, String codigoAnp) {
        this.descricao = descricao;
        this.descricaoIntegracao = descricaoIntegracao;
        this.identificadorExternoProdutoKurujao = codigoKurujao;
        this.identificadorExternoProdutoSim = codigoSim;
        this.codigoAnp = codigoAnp;
    }

    public static EnumModalidadeProdutoServico obterEnumPorDescricao(String combustivel) {
        for (EnumModalidadeProdutoServico e : EnumModalidadeProdutoServico.values()) {
            if (!e.getDescricaoIntegracao().contains(combustivel)) continue;
            return e;
        }
        return null;
    }

    public static EnumModalidadeProdutoServico obterEnumPorCodigoAnp(String codigoAnp) {
        for (EnumModalidadeProdutoServico e : EnumModalidadeProdutoServico.values()) {
            if (!StringUtils.isNotBlank((CharSequence)e.getCodigoAnp()) || !e.getCodigoAnp().contains(codigoAnp)) continue;
            return e;
        }
        return null;
    }

    public static EnumModalidadeProdutoServico obterEnumPorCodigo(Integer identificadorExternoProduto) {
        for (EnumModalidadeProdutoServico e : EnumModalidadeProdutoServico.values()) {
            if (identificadorExternoProduto == null) continue;
            if (e.getIdentificadorExternoProdutoKurujao() == identificadorExternoProduto.intValue()) {
                return e;
            }
            if (e.getIdentificadorExternoProdutoSim() != identificadorExternoProduto.intValue()) continue;
            return e;
        }
        return null;
    }

    public int getIdentificadorExternoProdutoKurujao() {
        return this.identificadorExternoProdutoKurujao;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String getCodigoAnp() {
        return this.codigoAnp;
    }

    public String getDescricaoIntegracao() {
        return this.descricaoIntegracao;
    }

    public int getIdentificadorExternoProdutoSim() {
        return this.identificadorExternoProdutoSim;
    }

    public void setIdentificadorExternoProdutoSim(int identificadorExternoProdutoSim) {
        this.identificadorExternoProdutoSim = identificadorExternoProdutoSim;
    }
}

