/*
 * Decompiled with CFR 0.152.
 */
package com.postoaki.venda;

import com.postoaki.venda.JavaBridge;
import com.postoaki.venda.PropertiesFactory;
import com.postoaki.venda.ThreadExecutadoraAcao;
import com.postoaki.venda.UtilLog;
import java.io.IOException;
import java.util.Objects;
import javafx.application.Application;
import javafx.concurrent.Worker;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import netscape.javascript.JSObject;

public class VendaBrowserMain
extends Application {
    public void start(Stage primaryStage) {
        try {
            if (!PropertiesFactory.getIsServico()) {
                System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
                System.setProperty("prism.lcdtext", "false");
                this.createWebView(primaryStage);
            }
        }
        catch (IOException e) {
            UtilLog.erro(e);
        }
    }

    private void createWebView(Stage primaryStage) throws IOException {
        JavaBridge javaBridge = new JavaBridge();
        StackPane sp = new StackPane();
        WebView webView = new WebView();
        ImageView imageView = new ImageView();
        imageView.setImage(new Image("images/loading.gif"));
        webView.getEngine().getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
            System.out.println(newValue);
            if (newValue != Worker.State.SUCCEEDED) {
                imageView.setVisible(true);
            }
            if (newValue == Worker.State.SUCCEEDED) {
                imageView.setVisible(false);
                JSObject window = (JSObject)webView.getEngine().executeScript("window");
                window.setMember("javaBridge", javaBridge);
                webView.getEngine().executeScript(String.format("window.codigoPosto = %s;", PropertiesFactory.getEmpresa()));
            }
        });
        sp.getChildren().add((Object)webView);
        sp.getChildren().add((Object)imageView);
        primaryStage.setScene(new Scene((Parent)sp));
        primaryStage.getIcons().add((Object)new Image("images/postoaki.jpg"));
        primaryStage.setTitle("POSTOAKI - M\u00d3DULO DE LAN\u00c7AMENTO DE VENDA");
        String url = PropertiesFactory.getUrl();
        if (Objects.nonNull(url)) {
            if (url.contains("producao")) {
                webView.getEngine().load("http://painelvenda.postoaki.com.br");
            } else if (url.contains("local")) {
                webView.getEngine().load("http://localhost:4200");
            } else if (url.contains("teste")) {
                webView.getEngine().load("http://painelvendatest.postoaki.com.br");
            } else {
                webView.getEngine().load(null);
            }
        }
        primaryStage.show();
    }

    public static void main(String[] args) {
        try {
            if (PropertiesFactory.loadProperties(args)) {
                if (PropertiesFactory.isServidor()) {
                    VendaBrowserMain.initThread();
                }
                VendaBrowserMain.launch((String[])args);
            }
        }
        catch (Exception e) {
            UtilLog.erro(e);
        }
    }

    public static void initThread() {
        ThreadExecutadoraAcao thread = new ThreadExecutadoraAcao("THREAD POSTO AKI SYNC");
        thread.setDaemon(true);
        thread.start();
    }
}

