/*
 * Decompiled with CFR 0.152.
 */
package com.postoaki.venda;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.postoaki.venda.ConexaoJdbcFactorySQLServer;
import com.postoaki.venda.PropertiesFactory;
import com.postoaki.venda.RestApi;
import com.postoaki.venda.UtilLog;
import com.postoaki.venda.com.postoaki.venda.dto.EnumModalidadeProdutoServico;
import com.postoaki.venda.com.postoaki.venda.dto.Integracao;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ThreadExecutadoraAcao
extends Thread {
    public ThreadExecutadoraAcao(String str) {
        super(str);
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.consultarRegistrosNaoSincronizados();
                if (PropertiesFactory.isAtualizarBancoLocal()) {
                    this.consultarVendasRealizadas(ThreadExecutadoraAcao.getUrlChamadaCompleta("/api/v1/integracao/vendas/empresa/" + PropertiesFactory.getEmpresa()), false);
                    if (PropertiesFactory.getIsIntegracaoCoonasa()) {
                        this.consultarVendasRealizadas("http://apicoonasa.postoaki.com/api/v1/integracao/vendas/empresa/" + PropertiesFactory.getEmpresa(), true);
                    }
                }
                Long tempoSinconizacao = PropertiesFactory.getTempoSinconizacao();
                ThreadExecutadoraAcao.sleep(tempoSinconizacao);
            }
        }
        catch (Exception e) {
            UtilLog.erro(e);
            return;
        }
    }

    private void consultarVendasRealizadas(String urlCompleta, boolean possuiIntegracaoCoonasa) throws Exception {
        try {
            String json = RestApi.get(urlCompleta);
            if (StringUtils.isEmpty((CharSequence)json)) {
                return;
            }
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
            List lista = (List)gson.fromJson(json, new TypeToken<List<Integracao>>(){}.getType());
            ArrayList<String> queries = new ArrayList<String>();
            ArrayList<Long> listaRegitrosSincronizados = new ArrayList<Long>();
            for (Integracao item : lista) {
                String nomeDoClienteSemAspas = item.getNomeCliente().replace("'", "");
                String formatoNomeCoonasa = String.format("%s - %s", "COONASA", nomeDoClienteSemAspas);
                String formatoNome = nomeDoClienteSemAspas;
                String nomeCliente = possuiIntegracaoCoonasa ? formatoNomeCoonasa : formatoNome;
                StringBuilder sql = new StringBuilder();
                sql.append(" UPDATE [Movimenta\u00e7\u00f5es em Vendas - Automa\u00e7\u00e3o] ");
                sql.append(" SET [ValorPorLitro] = " + item.getValorPorLitroDesconto());
                sql.append(" ,[ValorTotalDaVenda] =" + item.getValorVendaDesconto().setScale(2, RoundingMode.HALF_UP));
                sql.append(" ,[PAValorLitroAnterior] = " + item.getValorPorLitro().setScale(2, RoundingMode.HALF_UP));
                sql.append(" ,[PAValorVendaAnterior] = " + item.getValorVenda().setScale(2, RoundingMode.HALF_UP));
                sql.append(" ,[PACodigoCliente] = '" + item.getCodigoCliente() + "'");
                sql.append(" ,[PANomeCliente] = '" + nomeCliente + "'");
                sql.append(" ,[PACpf] = '" + item.getCpf() + "'");
                sql.append(" ,[PATelefone] = '" + item.getTelefone() + "'");
                sql.append(" ,[PAGrupo] = '" + item.getNomeGrupoDesconto() + "'");
                sql.append(" ,[PAImei] = '" + item.getImei() + "'");
                sql.append(" ,[PAEmail] = '" + item.getEmail() + "'");
                sql.append(" WHERE [C\u00f3digo] = " + item.getCodigoVendaExterno());
                System.out.println(sql.toString());
                listaRegitrosSincronizados.add(item.getId());
                queries.add(sql.toString());
            }
            if (!queries.isEmpty() && ConexaoJdbcFactorySQLServer.updateBatch(queries)) {
                this.atualizarRegitrosApiComoSincronizado(lista);
            }
        }
        catch (Exception e) {
            UtilLog.erro(e);
        }
    }

    private void atualizarRegitrosApiComoSincronizado(List<Integracao> listaRegitrosSincronizados) {
        try {
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
            RestApi.post(ThreadExecutadoraAcao.getUrlChamadaCompleta("/api/v1/integracao/atualizar-sincronizado"), gson.toJson(listaRegitrosSincronizados));
        }
        catch (Exception e) {
            UtilLog.erro(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarRegistrosNaoSincronizados() {
        Connection conexao = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT [Movimenta\u00e7\u00f5es em Vendas - Automa\u00e7\u00e3o].[C\u00f3digo] as id, ");
            sql.append(" [Qtde] as qtde,[Data_Movimento] as data, ");
            sql.append(" [ValorPorLitro] as valorLitro, ");
            sql.append(" [ValorTotalDaVenda] as valorTotalVenda, ");
            sql.append(" Funcion\u00e1rios.C\u00f3digo as funcionario_id, ");
            sql.append(" Funcion\u00e1rios.Nome as nome, ");
            sql.append(" Funcion\u00e1rios.Email as email, ");
            sql.append(" Funcion\u00e1rios.[PAValidacao] as senha, ");
            sql.append(" Tanques.C\u00f3digo as codigoTanque, ");
            sql.append(" Tanques.Descri\u00e7\u00e3o as combustivel, ");
            sql.append(" Tanques.GTIN as enum ");
            if (PropertiesFactory.getTemAnp()) {
                sql.append(" ,Produtos.IDANP as codigoAnp ");
            }
            sql.append(" FROM [Movimenta\u00e7\u00f5es em Vendas - Automa\u00e7\u00e3o] ");
            sql.append(" INNER JOIN [Funcion\u00e1rios] ON [Movimenta\u00e7\u00f5es em Vendas - Automa\u00e7\u00e3o].IDFuncionario = Funcion\u00e1rios.C\u00f3digo ");
            sql.append(" INNER JOIN Bombas ON [Movimenta\u00e7\u00f5es em Vendas - Automa\u00e7\u00e3o].Bomba = Bombas.[C\u00f3digo] ");
            sql.append(" INNER JOIN Tanques ON Bombas.Tanque = Tanques.C\u00f3digo ");
            if (PropertiesFactory.getTemAnp()) {
                sql.append(" INNER JOIN Produtos ON Tanques.IDCombustivel = Produtos.C\u00f3digo ");
            }
            sql.append(" WHERE  PASINCRONIZADO is null AND IsUtilizado = 0 ORDER BY [Movimenta\u00e7\u00f5es em Vendas - Automa\u00e7\u00e3o].[C\u00f3digo] DESC");
            conexao = ConexaoJdbcFactorySQLServer.criarConexaoSQLServer();
            ResultSet select = ConexaoJdbcFactorySQLServer.select(conexao, sql.toString());
            ArrayList<Integracao> lista = new ArrayList<Integracao>();
            while (select.next()) {
                Integracao integracao = new Integracao();
                integracao.setCodigoVendaExterno(select.getLong("id"));
                integracao.setData(select.getDate("data"));
                integracao.setValorPorLitro(select.getBigDecimal("valorLitro"));
                integracao.setQuantidade(select.getBigDecimal("qtde"));
                integracao.setValorVenda(select.getBigDecimal("valorTotalVenda"));
                integracao.setCodigoColaborador(select.getLong("funcionario_id"));
                integracao.setNomeColaborador(select.getString("nome"));
                integracao.setEmpresaIntegracao("TECSHOP");
                integracao.setEmailColaborador(this.obterEmailColaborador(select, integracao.getCodigoColaborador().toString()));
                integracao.setSenhaColaborador(this.obterSenhacolaborador(select));
                integracao.setDescricaoCombustivel(select.getString("combustivel"));
                if (PropertiesFactory.getTemAnp()) {
                    integracao.setModalidadeProduto(EnumModalidadeProdutoServico.obterEnumPorCodigoAnp(select.getString("codigoAnp")));
                } else {
                    integracao.setModalidadeProduto(EnumModalidadeProdutoServico.obterEnumPorDescricao(select.getString("enum")));
                }
                integracao.setCodigoGrupoEmpresa(PropertiesFactory.getGrupoEmpresa());
                integracao.setCodigoEmpresa(PropertiesFactory.getEmpresa());
                lista.add(integracao);
            }
            if (!lista.isEmpty()) {
                Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd").create();
                if (RestApi.post(ThreadExecutadoraAcao.getUrlChamadaCompleta("/api/v1/integracao/sincronizar"), gson.toJson(lista))) {
                    this.atualizarRegistrosBancoLocalComoSincronizado(lista);
                }
                if (PropertiesFactory.getIsIntegracaoCoonasa()) {
                    RestApi.post("http://apicoonasa.postoaki.com/api/v1/integracao/sincronizar", gson.toJson(lista));
                }
            }
        }
        catch (Exception e) {
            UtilLog.erro(e);
        }
        finally {
            try {
                conexao.close();
            }
            catch (SQLException e) {
                UtilLog.erro(e);
            }
        }
    }

    public static String getUrlChamadaCompleta(String urlChamada) {
        if (PropertiesFactory.getUrl().equals("producao")) {
            return "http://www.postoaki.com" + urlChamada;
        }
        if (PropertiesFactory.getUrl().equals("homologacao")) {
            return "http://localhost:8080" + urlChamada;
        }
        return "http://localhost:8080/postoaki" + urlChamada;
    }

    private String obterEmailColaborador(ResultSet select, String codigoColaborador) throws SQLException {
        String email = select.getString("email");
        return StringUtils.isEmpty((CharSequence)email) ? String.format("frentista.%s_%s@redebatista.com.br", PropertiesFactory.getEmpresa(), codigoColaborador) : email;
    }

    private String obterSenhacolaborador(ResultSet select) throws SQLException {
        String senha = select.getString("senha");
        return StringUtils.isEmpty((CharSequence)senha) ? "123" : senha;
    }

    private void atualizarRegistrosBancoLocalComoSincronizado(List<Integracao> lista) {
        try {
            ArrayList<String> queries = new ArrayList<String>();
            if (lista != null && !lista.isEmpty()) {
                for (Integracao item : lista) {
                    StringBuilder sql = new StringBuilder();
                    sql.append(" UPDATE [Movimenta\u00e7\u00f5es em Vendas - Automa\u00e7\u00e3o] ");
                    sql.append(" SET [PASincronizado] = 1");
                    sql.append(" WHERE [C\u00f3digo] = " + item.getCodigoVendaExterno());
                    System.out.println(sql.toString());
                    queries.add(sql.toString());
                }
                ConexaoJdbcFactorySQLServer.updateBatch(queries);
            }
        }
        catch (Exception e) {
            UtilLog.erro(e);
        }
    }
}

