/*
 * Decompiled with CFR 0.152.
 */
package com.postoaki.venda;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.postoaki.venda.ConexaoJdbcFactoryPostgres;
import com.postoaki.venda.PropertiesFactory;
import com.postoaki.venda.RestApi;
import com.postoaki.venda.ThreadExecutadoraAcao;
import com.postoaki.venda.UtilLog;
import com.postoaki.venda.com.postoaki.venda.dto.EnumModalidadeProdutoServico;
import com.postoaki.venda.com.postoaki.venda.dto.Produto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ThreadAtualizadoraPreco
extends Thread {
    public ThreadAtualizadoraPreco(String str) {
        super(str);
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.atualizarPrecos();
                Long tempoSinconizacao = PropertiesFactory.getTempoSinconizacao();
                ThreadAtualizadoraPreco.sleep(tempoSinconizacao);
            }
        }
        catch (Exception e) {
            UtilLog.erro(e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizarPrecos() {
        Connection conexao = null;
        try {
            String cnpj = PropertiesFactory.getCnpj();
            boolean isMultiEmpresa = StringUtils.isBlank((CharSequence)cnpj);
            StringBuilder sql = new StringBuilder();
            if (isMultiEmpresa) {
                sql.append(" select  c.cpf as cnpj, ");
                sql.append(" c.nome as nomeRazaoSocial, ");
                sql.append(" c.nome_reduzido, ");
                sql.append(" b.codigo as identificadorExternoProduto, ");
                sql.append(" b.nome as item, ");
                sql.append(" a.preco_custo as precoCusto, ");
                sql.append(" a.preco_unit as precoBomba, ");
                sql.append(" a.custo_medio ");
                sql.append(" from produto_empresa a ");
                sql.append(" inner join produto b on (a.produto = b.grid ) ");
                sql.append(" inner join empresa c on (a.empresa = c.grid) ");
                sql.append(" where   b.tipo = 'C' ");
                sql.append(" and a.preco_unit is not null");
                sql.append(" order by 1, 3 ");
            } else {
                sql.append(" select b.codigo as identificadorExternoProduto, ");
                sql.append(" b.nome as item, ");
                sql.append(" b.preco_unit as precoBomba ");
                sql.append(" from produto b ");
                sql.append(" where b.tipo = 'C' ");
                sql.append(" and b.preco_unit is not null");
                sql.append(" order by 1, 3 ");
            }
            conexao = ConexaoJdbcFactoryPostgres.criarConexaoPostgres();
            System.out.println("SQL Executado: " + sql);
            ResultSet select = ConexaoJdbcFactoryPostgres.select(conexao, sql.toString());
            if (select != null) {
                ArrayList<Produto> lista = new ArrayList<Produto>();
                while (select.next()) {
                    BigDecimal custoMedio;
                    BigDecimal precoCusto;
                    Produto p = new Produto();
                    if (isMultiEmpresa) {
                        p.setCodigoEmpresa(select.getString("cnpj").replaceAll("[^0-9]", ""));
                        p.setNomeFantasia(select.getString("nomeRazaoSocial"));
                    } else {
                        p.setCodigoEmpresa(cnpj.replaceAll("[^0-9]", ""));
                    }
                    p.setDescricaoProduto(select.getString("item"));
                    p.setIdentificadorExternoProduto(select.getInt("identificadorExternoProduto"));
                    p.setModalidadeProduto(EnumModalidadeProdutoServico.ETANOL);
                    p.setValor(select.getBigDecimal("precoBomba") != null ? select.getBigDecimal("precoBomba").setScale(4, RoundingMode.HALF_UP) : null);
                    if (isMultiEmpresa) {
                        precoCusto = select.getBigDecimal("precoCusto");
                        custoMedio = select.getBigDecimal("custo_medio");
                    } else {
                        precoCusto = BigDecimal.ONE;
                        custoMedio = BigDecimal.ONE;
                    }
                    if (precoCusto == null || precoCusto.doubleValue() == 0.0 || custoMedio == null || custoMedio.doubleValue() == 0.0 || p.getValor() == null || p.getValor().doubleValue() == 0.0) {
                        p.setStatus("INATIVO");
                    }
                    if (p.getModalidadeProduto() == null) continue;
                    lista.add(p);
                }
                if (!lista.isEmpty()) {
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd").create();
                    Map<String, List<Produto>> listaProdutosPorEmpresa = lista.stream().collect(Collectors.groupingBy(Produto::getCodigoEmpresa));
                    for (List<Produto> listaProduto : listaProdutosPorEmpresa.values()) {
                        System.out.println(String.format("Sincronizando Registros empresa: %s - %s", listaProduto.get(0).getCodigoEmpresa(), listaProduto.get(0).getNomeFantasia()));
                        if (!RestApi.post(ThreadExecutadoraAcao.getUrlChamadaCompleta("/api/v1/integracao/produto/lista"), gson.toJson(listaProduto))) continue;
                        System.out.println("---------------- Pre\u00e7os atualizados com sucesso! ------------");
                    }
                }
            }
        }
        catch (Exception e) {
            UtilLog.erro(e);
        }
        finally {
            try {
                if (conexao != null) {
                    conexao.close();
                }
            }
            catch (SQLException e) {
                UtilLog.erro(e);
            }
        }
    }

    private String obterDescricaoProduto(ResultSet select) throws SQLException {
        EnumModalidadeProdutoServico identificadorExternoProduto = EnumModalidadeProdutoServico.obterEnumPorCodigo(select.getInt("identificadorExternoProduto"));
        return identificadorExternoProduto != null ? identificadorExternoProduto.getDescricao() : null;
    }
}

