/*
 * Decompiled with CFR 0.152.
 */
package com.postoaki.venda;

import com.postoaki.venda.PropertiesFactory;
import com.postoaki.venda.UtilLog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.stream.Collectors;

public class RestApi {
    public static String get(String urlChamadaCompleta) {
        try {
            String output;
            URL url = new URL(urlChamadaCompleta);
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            String verbo = "GET";
            httpConn.setRequestMethod(verbo);
            httpConn.setRequestProperty("Accept", "application/json");
            if (httpConn.getResponseCode() != 200) {
                RestApi.getMensagemErro(httpConn);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));
            System.out.println("Resposta Servidor .... \n");
            StringBuffer sb = new StringBuffer();
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            httpConn.disconnect();
            String jsonRetorno = sb.toString();
            RestApi.printLogJson(verbo, jsonRetorno, urlChamadaCompleta);
            return jsonRetorno;
        }
        catch (Exception e) {
            UtilLog.erro(e);
            return null;
        }
    }

    public static boolean post(String urlChamadaCompleta, String json) {
        try {
            String output;
            String verbo = "POST";
            URL url = new URL(urlChamadaCompleta);
            RestApi.printLogJson(verbo, json, urlChamadaCompleta);
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod(verbo);
            httpConn.setRequestProperty("Content-Type", "application/json");
            DataOutputStream wr = new DataOutputStream(httpConn.getOutputStream());
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)wr, "UTF-8"));
            writer.write(json);
            writer.close();
            wr.close();
            if (httpConn.getResponseCode() != 200) {
                return RestApi.getMensagemErro(httpConn);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));
            System.out.println("Resposta do servidor .... \n");
            while ((output = br.readLine()) != null) {
                System.out.println(output);
            }
            httpConn.disconnect();
            return true;
        }
        catch (Exception e) {
            UtilLog.erro(e);
            return false;
        }
    }

    private static boolean getMensagemErro(HttpURLConnection httpConn) throws IOException {
        InputStream inputStream = httpConn.getResponseCode() < 400 ? httpConn.getInputStream() : httpConn.getErrorStream();
        BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String mensagemErro = rd.lines().collect(Collectors.joining());
        throw new RuntimeException("Falha : HTTP c\u00f3digo erro: C\u00f3digo: " + httpConn.getResponseCode() + " Mensagem: " + mensagemErro);
    }

    public static void printLogJson(String verbo, String json, String url) throws IOException {
        if (PropertiesFactory.getJson()) {
            File arquivoLogJson;
            File f = new File("log");
            if (!f.exists()) {
                f.mkdir();
            }
            if (!(arquivoLogJson = new File("log/json.txt")).exists()) {
                arquivoLogJson.createNewFile();
            }
            String impressaoLog = String.format("Data: %s - Verbo: %s - URL: %s - Json: %s", new SimpleDateFormat("dd/MM/yyyy HH:ss").format(new Date()), verbo, url, json);
            BufferedWriter output = new BufferedWriter(new FileWriter(arquivoLogJson.getAbsoluteFile(), true));
            output.append(impressaoLog);
            output.append("\r");
            ((Writer)output).close();
        }
    }
}

