/*
 * Decompiled with CFR 0.152.
 */
package com.postoaki.venda;

import com.postoaki.venda.UtilLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.time.LocalDate;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class PropertiesFactory {
    private static final String EMPRESA = "empresa";
    private static final String GRUPO_EMPRESA = "grupoEmpresa";
    private static final String IP_BANCO = "ipBanco";
    private static final String NOME_BANCO = "nomeBanco";
    private static final String USUARIO_BANCO = "usuarioBanco";
    private static final String CNPJ = "cnpj";
    private static final String SENHA_BANCO = "senhaBanco";
    private static final String SERVIDOR = "servidor";
    private static final String TEMPOSINCRONIZACAO = "temposincronizacao";
    private static final String URL = "url";
    private static final String ATUALIZAR_BANCO_LOCAL = "atualizarBancoLocal";
    private static final String JSON = "json";
    private static final String SERVICE = "service";
    private static final String ATUALIZAR_PRECO = "atualizarPreco";
    private static final String INTEGRACAO_COONASA = "integracaoCoonasa";
    private static final String XPERT = "xpert";
    private static final String ATUALIZAR_DADOS_USUARIO = "atualizarDadosUsuario";
    private static final String TEM_ANP = "temAnp";
    private static String CAMINHO = "config.properties";

    private static Properties obterProperties() {
        try {
            Properties props = new Properties();
            FileInputStream file = new FileInputStream(CAMINHO);
            props.load(file);
            return props;
        }
        catch (IOException e) {
            UtilLog.erro(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadProperties(String[] args) {
        OutputStreamWriter fileWriter = null;
        try {
            File file;
            if (args == null || args.length == 0) {
                file = new File(CAMINHO);
            } else {
                CAMINHO = args[0];
                file = new File(args[0]);
            }
            if (!file.exists()) {
                Properties properties = new Properties();
                properties.setProperty(EMPRESA, "315173");
                properties.setProperty(GRUPO_EMPRESA, "13");
                properties.setProperty(IP_BANCO, "sem_ip");
                properties.setProperty(NOME_BANCO, "sem_banco");
                properties.setProperty(USUARIO_BANCO, "sa");
                properties.setProperty(SENHA_BANCO, "sem_senha");
                properties.setProperty(TEMPOSINCRONIZACAO, "15000");
                properties.setProperty(URL, "producao");
                properties.setProperty(SERVIDOR, "false");
                properties.setProperty(ATUALIZAR_BANCO_LOCAL, "false");
                properties.setProperty(SERVICE, "false");
                fileWriter = new FileWriter(CAMINHO);
                properties.store(fileWriter, String.format("Author: Auto - Data: %s", LocalDate.now()));
            }
            PropertiesFactory.validarPropriedades();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            UtilLog.erro(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    UtilLog.erro(e);
                }
            }
        }
    }

    private static void validarPropriedades() throws Exception {
        if (PropertiesFactory.getEmpresa() == null && PropertiesFactory.isServidor()) {
            throw new Exception("O c\u00f3digo da empresa \u00e9 obrigat\u00f3rio para realizar integracao");
        }
        if (PropertiesFactory.isServidor() && PropertiesFactory.getTempoSinconizacao() < 5000L) {
            throw new Exception("O tempo de sincronizacao n\u00e3o pode ser inferior a 5 segundos");
        }
    }

    public static boolean isAtualizarBancoLocal() {
        return Boolean.parseBoolean(PropertiesFactory.obterProperties().getProperty(ATUALIZAR_BANCO_LOCAL));
    }

    public static String getIpBanco() {
        return PropertiesFactory.obterProperties().getProperty(IP_BANCO);
    }

    public static String getSenhaBanco() {
        String senhaBanco = PropertiesFactory.obterProperties().getProperty(SENHA_BANCO);
        if (StringUtils.isEmpty((CharSequence)senhaBanco)) {
            throw new IllegalArgumentException("A senha do banco de dados n\u00e3o foi configurada");
        }
        return senhaBanco;
    }

    public static String getUsuarioBanco() {
        String usuarioBancoDados = PropertiesFactory.obterProperties().getProperty(USUARIO_BANCO);
        if (StringUtils.isEmpty((CharSequence)usuarioBancoDados)) {
            throw new IllegalArgumentException("O usu\u00e1rio do banco de dados n\u00e3o foi configurado");
        }
        return usuarioBancoDados;
    }

    public static boolean getTemAnp() {
        return Boolean.parseBoolean(PropertiesFactory.obterProperties().getProperty(TEM_ANP));
    }

    public static String getCnpj() {
        return PropertiesFactory.obterProperties().getProperty(CNPJ);
    }

    public static String getNomeBanco() {
        String nomeBanco = PropertiesFactory.obterProperties().getProperty(NOME_BANCO);
        if (StringUtils.isEmpty((CharSequence)nomeBanco)) {
            throw new IllegalArgumentException("O nome do banco de dados n\u00e3o foi configurado");
        }
        return nomeBanco;
    }

    public static String getUrl() {
        return PropertiesFactory.obterProperties().getProperty(URL);
    }

    public static Long getGrupoEmpresa() {
        return Long.valueOf(PropertiesFactory.obterProperties().getProperty(GRUPO_EMPRESA));
    }

    public static Long getEmpresa() {
        return Long.valueOf(PropertiesFactory.obterProperties().getProperty(EMPRESA));
    }

    public static boolean isServidor() {
        return Boolean.parseBoolean(PropertiesFactory.obterProperties().getProperty(SERVIDOR));
    }

    public static Long getTempoSinconizacao() {
        return Long.valueOf(PropertiesFactory.obterProperties().getProperty(TEMPOSINCRONIZACAO));
    }

    public static boolean getJson() {
        return Boolean.parseBoolean(PropertiesFactory.obterProperties().getProperty(JSON));
    }

    public static boolean getIsAtualizarPreco() {
        return Boolean.parseBoolean(PropertiesFactory.obterProperties().getProperty(ATUALIZAR_PRECO));
    }

    public static boolean getIsServico() {
        return Boolean.parseBoolean(PropertiesFactory.obterProperties().getProperty(SERVICE));
    }

    public static boolean getIsXpert() {
        return Boolean.parseBoolean(PropertiesFactory.obterProperties().getProperty(XPERT));
    }

    public static boolean getIsIntegracaoCoonasa() {
        return Boolean.parseBoolean(PropertiesFactory.obterProperties().getProperty(INTEGRACAO_COONASA));
    }
}

