/*
 * Decompiled with CFR 0.152.
 */
package com.postoaki.venda;

import com.postoaki.venda.PdfViewer;
import com.postoaki.venda.PropertiesFactory;
import com.postoaki.venda.UtilLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.codehaus.jettison.json.JSONObject;

public class JavaBridge {
    public void imprimirComprovanteVenda(long vendaId) {
        try {
            String filePath = "relatorio.pdf";
            File file = new File(filePath);
            file.delete();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("idVenda", vendaId);
            String encode = URLEncoder.encode(jsonObject.toString(), "UTF-8");
            System.out.println(encode);
            URL url = new URL("http://www.postoaki.com/venda/v1/nova-venda/imprimir-venda/" + vendaId);
            this.enviarRequisicao(filePath, url);
        }
        catch (Exception e) {
            UtilLog.erro(e);
        }
    }

    public void imprimirRelatorio(long colaboradorId, long empresaId, long data) {
        try {
            String filePath = "relatorio.pdf";
            File file = new File(filePath);
            file.delete();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("idColaborador", colaboradorId);
            jsonObject.put("idEmpresa", empresaId);
            jsonObject.put("data", data);
            String encode = URLEncoder.encode(jsonObject.toString(), "UTF-8");
            System.out.println(encode);
            URL url = new URL("http://www.postoaki.com/venda/v1/relatorio/vendasdiario/grupoempresa/" + PropertiesFactory.getGrupoEmpresa() + "/imprimir?filtros=" + encode);
            this.enviarRequisicao(filePath, url);
        }
        catch (Exception e) {
            UtilLog.erro(e);
        }
    }

    private void enviarRequisicao(String filePath, URL url) throws IOException {
        int bytesRead;
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        InputStream initialStream = con.getInputStream();
        byte[] buffer = new byte[1024];
        FileOutputStream os = new FileOutputStream(new File(filePath));
        while ((bytesRead = initialStream.read(buffer)) != -1) {
            ((OutputStream)os).write(buffer, 0, bytesRead);
        }
        initialStream.close();
        os.flush();
        ((OutputStream)os).close();
        PdfViewer.visualizar(filePath);
    }
}

